define(['angular', 'app', 'RequestsService', 'moment', 'VarUtilityConstants'], function (angular, app) {
	'use strict';
	app.controller('RequestsController', function ($scope, $http, $q,
		RequestsService, focusService, connectionErrorService, modalService, formatter, requestsConstants, activeInstitution) {
		focusService.focusMain();
		$scope.formatter = formatter;
		$scope.today = new Date();
		$scope.institution = activeInstitution.divisionName;

		$scope.supportedMenu = [
			{value: 'No', response: 'Yes - Any Veteran'},
			{value: 'Yes', response: 'Yes - Based Upon Time Frame'}
		];

		$scope.lastSeenMenu = [
			{value: 730, days: '24 months (730 days)'},
			{value: 365, days: '12 months (365 days)'}
		];

		$scope.request = $scope.lastSavedRequest = {};

		function saveCurrentState() {
            $scope.lastSavedRequest = angular.copy($scope.request);
            $scope.lastSavedExpressCare = angular.copy($scope.expressCare);
        }

        function configureCustomSettings() {
            $scope.expressCare = _.find($scope.request.customRequestSettings, function (setting) {
                return setting.id === requestsConstants.EXPRESS_CARE_ID;
            });

            if (!_.isEmpty($scope.expressCare)) {
                if ($scope.expressCare.enterpriseSubmittedRequestLimit === undefined ||
                    $scope.expressCare.enterpriseSubmittedRequestLimit === null ||
                    $scope.expressCare.enterpriseSubmittedRequestLimit === 0) {
                    $scope.expressCare.supported = false;
                    $scope.expressCare.enterpriseSubmittedRequestLimit = 0;
                    $scope.enterpriseSubmittedRequestLimitZero = true;
                } else {
                    $scope.maxCustomSettingsSubmittedRequestMenu = buildMaxSubmittedRequestMenu($scope.expressCare.enterpriseSubmittedRequestLimit);
                }
            }
        }

		RequestsService.fetch(activeInstitution.childName).then(function(response) {
			if(response.status !== 200) {
				return connectionErrorService.showServerErrorMsg(response);
			}

			// update request model
            $scope.request = response.data;

            configureCustomSettings();

            // update form state
            saveCurrentState();

			$scope.maxSubmittedRequestMenu = (function() {
				var maxSubmittedRequestLimits = [];
				for (var i = 0; i < $scope.request.requestSettings.length; i++) {
					if ($scope.request.requestSettings[i].enterpriseSubmittedRequestLimit === 0) {
						setModelForDisabled(i);
					} else {
						if ($scope.request.requestSettings[i].submittedRequestLimit > $scope.request.requestSettings[i].enterpriseSubmittedRequestLimit) {
							$scope.request.requestSettings[i].submittedRequestLimit = $scope.request.requestSettings[i].enterpriseSubmittedRequestLimit;
							$scope.lastSavedRequest.requestSettings[i].submittedRequestLimit = $scope.request.requestSettings[i].enterpriseSubmittedRequestLimit;
						}
						maxSubmittedRequestLimits.push($scope.request.requestSettings[i].enterpriseSubmittedRequestLimit);
					}
				}
				var largest = Math.max.apply(null, maxSubmittedRequestLimits);
				return buildMaxSubmittedRequestMenu(largest);
			})();
		});

		var modalOptions = {
			actionButtonText: 'OK',
			headerText: 'Confirmation',
			bodyText: 'The Request settings have been saved.'
		};

		$scope.$watch('expressCare.supported', function (newVal, oldVal) {
			if ($scope.expressCare && !newVal) {
                _.each($scope.expressCare.schedulingDays, function (dailySchedule) {
					dailySchedule.canSchedule = false;
                    dailySchedule.startTime = '';
                    dailySchedule.endTime = '';
                });
			}

			if (oldVal === false && newVal === true) {
                $scope.expressCare.submittedRequestLimit = $scope.expressCare.enterpriseSubmittedRequestLimit;
            }
		}, true);

        function capitalize(input) {
            return input.charAt(0).toUpperCase() + input.substr(1).toLowerCase();
        }

        function isInValidTimeFormat(input) {
			return /^(\d{2})\:(\d{2})$/.test(input);
        }

        $scope.save = function(e){
			var fDNS   troller = this.requestForm;
			fDNS   troller.$setSubmitted();

            if (!_.isEmpty($scope.expressCare) && $scope.expressCare.supported) {
            	var errorGroup = [];
                var numOfActiveDailySchedule = 0;
                _.each($scope.expressCare.schedulingDays, function (dailySchedule) {
                    if (dailySchedule.canSchedule) {
                        ++numOfActiveDailySchedule;
                        var readyToCheckTimeRange = true;
                        if (!!dailySchedule.startTime && !isInValidTimeFormat(dailySchedule.startTime)) {
							errorGroup.push(capitalize(dailySchedule.day) + ' Start Time must be formatted hh:mm.');
                            readyToCheckTimeRange = false;
                            // fDNS   troller[dailySchedule.day + '-start-time'].$setValidity('pattern', false);
						}

                        if (!!dailySchedule.endTime && !isInValidTimeFormat(dailySchedule.endTime)) {
                            errorGroup.push(capitalize(dailySchedule.day) + ' End Time must be formatted hh:mm.');
                            readyToCheckTimeRange = false;
                            // fDNS   troller[dailySchedule.day + '-end-time'].$setValidity('pattern', false);
                        }

                        if (readyToCheckTimeRange && !!dailySchedule.startTime && !! dailySchedule.endTime) {
							// check the time range
							var startDate = new Date("12/12/1212 " + dailySchedule.startTime);
							var endDate = new Date("12/12/1212 " + dailySchedule.endTime);

							if (startDate >= endDate) {
								errorGroup.push(capitalize(dailySchedule.day) + ' Start time must be before End Time.');
                                // fDNS   troller[dailySchedule.day + '-start-time'].$setValidity('pattern', false);
                            }
                        }
                    }
                });

                if (numOfActiveDailySchedule === 0) {
                    errorGroup.push('At least one day must be selected to support an ' + $scope.expressCare.typeOfCare + ' request.');
                }
            }

			fDNS   troller.validationSummary.requiredValidate(errorGroup).then(function() {
                if (fDNS   troller.validationSummary.hasError()) {
                    focusService.focusElement('.validation-summary h5');
                    return;
                }

				var httpRequestPromise = RequestsService.save($scope.request,activeInstitution.childName).then(function(response){
					// update request model
					$scope.request = response.data;

					fDNS   troller.$setPristine();
					fDNS   troller.validationSummary.clear();

                    configureCustomSettings();

                    // update form state
                    saveCurrentState();

                    // show confirmation modal
					modalService.showModal({}, modalOptions).then(function () {
						focusService.focusPrimary();
					});
				});

				fDNS   troller.validationSummary.summarizeAsync([httpRequestPromise]);
			});
		};

		$scope.resetTypeOfCare = function(){
			var fDNS   troller = this.requestForm;
			fDNS   troller.validationSummary.clear();
			fDNS   troller.$setPristine();
			$scope.request = angular.copy($scope.lastSavedRequest);

            _.find($scope.request.requestSettings, function(setting, index) {
                if (setting.id === 'CR1') {
                    $scope.request.requestSettings[index] = angular.copy($scope.lastSavedExpressCare);
                    return true;
                }
                return false;
            });
		};

        $scope.resetExpressCare = function(){
            var fDNS   troller = this.requestForm;
            fDNS   troller.validationSummary.clear();
            fDNS   troller.$setPristine();
            $scope.expressCare = angular.copy($scope.lastSavedExpressCare);

			_.find($scope.request.customRequestSettings, function(setting, index) {
                if (setting.id === 'CR1') {
                    $scope.request.customRequestSettings[index] = $scope.expressCare;
					return true;
				}
				return false;
			});
        };

		$scope.isDisabled = function(value) {
			return value === 0;
		};

		function setModelForDisabled(index) {
			$scope.request.requestSettings[index].patientHistoryRequired = '';
			$scope.request.requestSettings[index].submittedRequestLimit = 0;
		}

		function buildMaxSubmittedRequestMenu(number) {
			var limits = [];
			build(number);
			function build(number) {
				if (number > 0) {
					limits.push({value: number, max: number});
					return build(number - 1);
				} else {
					return number;
				}
			}
			return limits.reverse();
		}

		$scope.constructFieldName = function(day) {
			return (formatter.toDashCase($scope.expressCare.typeOfCare) + '-' + day);
		}
	});

    app.controller('SchedulingDaysController', function ($scope, $controller) {
        // $controller('RequestsController', { $scope: $scope });
    	$scope.$watch('schedulingDay.canSchedule', function (newVal, oldVal) {
            if (oldVal === true && newVal === false) {
                $scope.schedulingDay.startTime = "";
                $scope.schedulingDay.endTime = "";
			}
        })
    });
});
